//
//  NSAttributedString+MergeTokenAdditions.h
//  TokenMergeTest
//
//  Created by Alykhan Jetha on 28/10/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCMergeTokenAttachment;

@interface NSAttributedString (MergeTokenAdditions)
- (NSRange)nextRangeWithAttributeName:(NSString *)aName getMergeTokenValue:(MCMergeTokenAttachment **)aValue startIndex:(unsigned)sIndex forward:(BOOL)forward;

// returns all the label names - including duplicates
- (NSArray *)tokens;
- (NSArray *)tokenLabelNames;
- (NSArray *)tokenWithLabelName:(NSString *)aName;
- (NSArray *)tokensWithKeyPathContaining:(NSString *)aKeyPath;
- (NSArray *)tokensWithFormatterCode:(int)aFormatterCode;

// returns the range of a token with a given label name - call this until NSNotFound or 0,0 is returned since there can be more than one token with the same label name
- (NSRange)nextRangeOfTokenWithLabel:(NSString *)aLabel;

- (NSRange)nextRangeOfTokenContainingKeyPath:(NSString *)aKeyPath;

- (BOOL)replaceKeyPath:(NSString *)aKeyPath withKeyPath:(NSString *)aNewKeyPath;

@end


@interface NSTextStorage (MergeTokenAdditions)
- (void)performTokenMergeWithObject:(id)args arguments:(id)other applyFormatter:(BOOL)applyFormatter;

// anObjThatResponds should respond to formatterForFormatCode. If nil is passed, then the default formatter manager is used
- (void)performTokenMergeWithObject:(id)args arguments:(id)other applyFormatter:(BOOL)applyFormatter formatterCodeProvidor:(id)anObjThatResponds;

- (void)removeAllOccurencesOfMergeTokensWithLabel:(NSString *)aLabel;
- (void)removeAllOccurencesOfMergeTokensWithKeyPathContaining:(NSString *)aKp;

- (void)changeToFontWithNameMaintainPointSize:(NSString *)aFontName;
@end
